<?php
/*
Plugin Name: VIPCART Integration
Plugin URI: https://vipcart.eu
Description: Easy integration of VipCart system with a simple settings panel to set up your web business in less than 5 minutes!
Version: 1.0
Author: vipcart.eu
Author URI: https://vipcart.eu
*/

// Register settings
function vipcart_register_settings()
{
    register_setting('vipcart_settings_group', 'vipcart_user_id');

    // Check if 'userid' parameter is present in URL and store it
    if (isset($_GET['userid'])) {
        $user_id = sanitize_text_field($_GET['userid']);
        update_option('vipcart_user_id', $user_id);
        add_action('admin_notices', 'vipcart_success_notice');
    }
}
add_action('admin_init', 'vipcart_register_settings');

// Success notice when User ID is fetched and saved
function vipcart_success_notice()
{
    ?>
    <div class="notice notice-success is-dismissible">
        <p style="font-size: 18px;">
            <strong>Successfully FETCHED your VipCart User ID and saved it in your WordPress Site!</strong><br />
            VipCart is now active, and you can start building your web shop with simple links!
            For more help, go to <a href="https://vipcart.eu/" target="_blank" style="font-weight: bold;">VipCart
                Help</a>, and you'll be up and running in no time.
        </p>
    </div>
    <?php
}

// Add settings page
function vipcart_add_admin_menu()
{
    add_options_page(
        'VipCart Settings',
        'VipCart',
        'manage_options',
        'vipcart',
        'vipcart_settings_page'
    );
}
add_action('admin_menu', 'vipcart_add_admin_menu');

// Settings page HTML
function vipcart_settings_page()
{
    $user_id = get_option('vipcart_user_id');
    ?>
    <div class="wrap">
        <h1 style="font-size: 32px; margin-bottom: 20px;">VipCart Settings</h1>
        <a href="https://vipcart.eu/?l=3" target="_blank" class="button button-secondary"
            style="font-size: 16px; margin-bottom: 20px;"> VipCart CONTROL PANEL </a>
                <a href="https://vipcart.eu/" target="_blank" class="button button-secondary"
                    style="font-size: 16px; margin-bottom: 20px;">Get Help on VipCart</a>
                <form method="post" action="options.php" style="background: #f9f9f9; padding: 20px; border-radius: 8px;">
                    <?php
                    settings_fields('vipcart_settings_group');
                    do_settings_sections('vipcart');
                    ?>
                    <div style="margin-top: 10px; font-size: 16px;">
                        To start using VipCart, simply fill your vipcart.eu User ID in this box. If you are logged in
                        on vipcart.eu you can click the "Fetch VipCart User ID".
                        Otherwise you will find your VipCart User ID on your Control Panel in VipCart, copy it and paste it into the VipCart User ID box below. Then click "Save Settings"</div>
                    <table class="form-table" style="font-size: 18px; width: 100%;">
                        <tr valign="top">
                            <th scope="row" style="width: 200px;">VipCart User ID</th>
                            <td>
                                <input type="text" id="vipcart_user_id" name="vipcart_user_id"
                                    value="<?php echo esc_attr($user_id); ?>"
                                    style="width: 100%; max-width: 400px; font-size: 16px;" />

                            </td>
                        </tr>
                    </table>
                    <button
                        title="If you are logged in on your vipcart.eu account, you can click the Fetch-button below to automatically get your VipCart User ID and get started quickly creating your Shop."
                        type="button" id="get_vipcart_user_id" class="button button-primary"
                        style="font-size: 16px; margin-top: 10px;">Fetch VipCart User ID</button>
                    <?php submit_button('Save Settings', 'primary', 'submit', true, ['style' => 'font-size: 18px; margin-top: 20px;']); ?>
                </form>
    </div>
    <script>
        document.getElementById('get_vipcart_user_id').addEventListener('click', function () {
            window.open('https://vipcart.eu/get_user_id?redirect_to=<?php echo urlencode(admin_url('options-general.php?page=vipcart')); ?>', '_blank');
        });
    </script>
    <?php
}

// Include the script in the head
function vipcart_include_script()
{
    $user_id = get_option('vipcart_user_id');
    if ($user_id) {
        echo '<script src="https://vipcart.eu?i=' . esc_attr($user_id) . '"></script>';
    }
}
add_action('wp_head', 'vipcart_include_script');

// Add settings link and other links on the Plugins page
function vipcart_plugin_action_links($links)
{
    $settings_link = '<a href="options-general.php?page=vipcart" style="font-weight: bold;">Settings</a>';
    $support_link = '<a href="https://vipcart.eu/contactus" target="_blank" style="font-weight: bold;">Get Support</a>';
    $website_link = '<a href="https://vipcart.eu" target="_blank" style="font-weight: bold;">By VipCart</a>';

    array_unshift($links, $settings_link);
    $links[] = $support_link;

    return $links;
}
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'vipcart_plugin_action_links');
